/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.DangerZone;
import dangerzone.Player;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.entities.Cockroach;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import org.newdawn.slick.opengl.Texture;

public class Criminal
extends EntityLiving {
    public Criminal(World w) {
        super(w);
        this.maxrenderdist = 120;
        this.height = 2.33f;
        this.width = 2.25f;
        this.uniquename = "OreSpawn:Criminal";
        this.moveSpeed = 0.28f;
        this.setMaxHealth(80.0f);
        this.setHealth(80.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(5.0f);
        this.searchDistance = 16.0f;
        this.attackRange = 4.0f;
        this.movefrequency = 65;
        this.setExperience(199);
        this.canSwim = true;
        this.has_inventory = true;
        this.setBID(-1);
        this.setBID(DangerZone.rand.nextInt(2));
        this.temperament = 1;
        this.enable_hostile = true;
        this.tower_defense_enable = true;
    }

    public String getLivingSound() {
        if (this.world.rand.nextBoolean()) {
            return null;
        }
        return "DangerZone:coin_shake";
    }

    public String getHurtSound() {
        return "DangerZone:coin_drop";
    }

    public String getDeathSound() {
        return "DangerZone:coin_jingle";
    }

    public void doAttack(Entity victim) {
        if (victim.has_inventory && victim instanceof Player) {
            Player p = (Player)victim;
            int k = -1;
            int kp = -1;
            int i = 99;
            while (i >= 0) {
                if (this.entity_inventory[i] == null) {
                    k = i;
                    break;
                }
                --i;
            }
            if (k >= 0) {
                i = p.entity_inventory.length - 1;
                while (i >= 0) {
                    if (p.entity_inventory[i] != null) {
                        kp = i;
                        break;
                    }
                    --i;
                }
                if (kp >= 0) {
                    this.setCanDespawn(false);
                    this.setVarInventory(k, p.getVarInventory(kp));
                    p.setVarInventory(kp, null);
                    this.world.playSound("DangerZone:coin_deposit", this.dimension, this.posx, this.posy, this.posz, 1.0f, 1.0f);
                }
            }
        }
        super.doAttack(victim);
    }

    public void doDeathDrops() {
        int howmany = 3 + this.world.rand.nextInt(5);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.coinsilver.itemID, (float)2.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 3 + this.world.rand.nextInt(5);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.coingold.itemID, (float)2.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 3 + this.world.rand.nextInt(5);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.coinplatinum.itemID, (float)2.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophycriminal.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        super.doDeathDrops();
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Criminal) {
            return false;
        }
        if (e instanceof Cockroach) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/Criminaltexture.png");
        }
        return this.texture;
    }
}

